/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalID
extends CPPEvaluation {
    private final ICPPEvaluation fFieldOwner;
    private final char[] fName;
    private final IBinding fNameOwner;
    private final boolean fAddressOf;
    private final boolean fQualified;
    private final ICPPTemplateArgument[] fTemplateArgs;

    public EvalID(ICPPEvaluation fieldOwner, IBinding nameOwner, char[] simpleID, boolean addressOf, boolean qualified, ICPPTemplateArgument[] templateArgs) {
        this.fFieldOwner = fieldOwner;
        this.fName = simpleID;
        this.fNameOwner = nameOwner;
        this.fAddressOf = addressOf;
        this.fQualified = qualified;
        this.fTemplateArgs = templateArgs;
    }

    public ICPPEvaluation getFieldOwner() {
        return this.fFieldOwner;
    }

    public IBinding getNameOwner() {
        return this.fNameOwner;
    }

    public char[] getName() {
        return this.fName;
    }

    public boolean isAddressOf() {
        return this.fAddressOf;
    }

    public boolean isQualified() {
        return this.fQualified;
    }

    public ICPPTemplateArgument[] getTemplateArgs() {
        return this.fTemplateArgs;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        return true;
    }

    @Override
    public boolean isValueDependent() {
        return true;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        return new TypeOfDependentExpression(this);
    }

    @Override
    public IValue getValue(IASTNode point) {
        return Value.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        int firstByte = 10;
        if (this.fAddressOf) {
            firstByte |= 0x10;
        }
        if (this.fQualified) {
            firstByte |= 0x20;
        }
        if (this.fTemplateArgs != null) {
            firstByte |= 0x40;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalEvaluation(this.fFieldOwner, false);
        buffer.putCharArray(this.fName);
        buffer.marshalBinding(this.fNameOwner);
        if (this.fTemplateArgs != null) {
            buffer.putShort((short)this.fTemplateArgs.length);
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.fTemplateArgs;
            int n = this.fTemplateArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                buffer.marshalTemplateArgument(arg);
                ++n2;
            }
        }
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        boolean addressOf = (firstByte & 0x10) != 0;
        boolean qualified = (firstByte & 0x20) != 0;
        ICPPEvaluation fieldOwner = (ICPPEvaluation)buffer.unmarshalEvaluation();
        char[] name = buffer.getCharArray();
        IBinding nameOwner = buffer.unmarshalBinding();
        ICPPTemplateArgument[] args = null;
        if ((firstByte & 0x40) != 0) {
            int len = buffer.getShort();
            args = new ICPPTemplateArgument[len];
            int i = 0;
            while (i < args.length) {
                args[i] = buffer.unmarshalTemplateArgument();
                ++i;
            }
        }
        return new EvalID(fieldOwner, nameOwner, name, addressOf, qualified, args);
    }

    public static ICPPEvaluation create(IASTIdExpression expr) {
        IType fieldOwnerType;
        IASTName name = expr.getName();
        IBinding binding = name.resolvePreBinding();
        if (binding instanceof IProblemBinding || binding instanceof IType || binding instanceof ICPPConstructor) {
            return EvalFixed.INCOMPLETE;
        }
        if (binding instanceof CPPFunctionSet) {
            return new EvalFunctionSet((CPPFunctionSet)binding, EvalID.isAddressOf(expr));
        }
        if (binding instanceof ICPPUnknownBinding) {
            IBinding owner = binding.getOwner();
            if (owner instanceof IProblemBinding) {
                return EvalFixed.INCOMPLETE;
            }
            EvalFixed fieldOwner = null;
            IType fieldOwnerType2 = EvalID.withinNonStaticMethod(expr);
            if (fieldOwnerType2 != null) {
                fieldOwner = new EvalFixed(fieldOwnerType2, IASTExpression.ValueCategory.LVALUE, Value.UNKNOWN);
            }
            ICPPTemplateArgument[] templateArgs = null;
            IASTName lastName = name.getLastName();
            if (lastName instanceof ICPPASTTemplateId) {
                templateArgs = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)lastName);
            }
            return new EvalID(fieldOwner, owner, name.getSimpleID(), EvalID.isAddressOf(expr), name instanceof ICPPASTQualifiedName, templateArgs);
        }
        if (binding instanceof ICPPMember && !(binding instanceof IType) && !(binding instanceof ICPPConstructor) && !((ICPPMember)binding).isStatic() && (fieldOwnerType = EvalID.withinNonStaticMethod(expr)) != null) {
            return new EvalMemberAccess(fieldOwnerType, IASTExpression.ValueCategory.LVALUE, binding, true);
        }
        if (binding instanceof IEnumerator) {
            ICPPEnumeration enumType;
            IType type = ((IEnumerator)binding).getType();
            if (type instanceof ICPPEnumeration && (enumType = (ICPPEnumeration)type).asScope() == CPPVisitor.getContainingScope(expr)) {
                type = enumType.getFixedType();
                if (type == null) {
                    type = CPPSemantics.INT_TYPE;
                }
                return new EvalBinding(binding, type);
            }
            return new EvalBinding(binding, null);
        }
        if (binding instanceof ICPPTemplateNonTypeParameter || binding instanceof IVariable || binding instanceof IFunction) {
            return new EvalBinding(binding, null);
        }
        return EvalFixed.INCOMPLETE;
    }

    private static IType withinNonStaticMethod(IASTExpression expr) {
        ICPPASTFunctionDefinition fdef;
        IBinding methodBinding;
        IASTNode parent = expr.getParent();
        while (parent != null && !(parent instanceof ICPPASTFunctionDefinition)) {
            parent = parent.getParent();
        }
        if (parent instanceof ICPPASTFunctionDefinition && (methodBinding = (fdef = (ICPPASTFunctionDefinition)parent).getDeclarator().getName().resolvePreBinding()) instanceof ICPPMethod && !((ICPPMethod)methodBinding).isStatic()) {
            IScope scope = CPPVisitor.getContainingScope(expr);
            return CPPVisitor.getImpliedObjectType(scope);
        }
        return null;
    }

    private static boolean isAddressOf(IASTIdExpression expr) {
        IASTNode e = expr.getParent();
        while (e instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)e;
            int op = unary.getOperator();
            if (op == 11) {
                e = unary.getOperand();
                continue;
            }
            return op == 5;
        }
        return false;
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation eval;
        IType type;
        IBinding nameOwner;
        ICPPEvaluation fieldOwner;
        ICPPTemplateArgument[] templateArgs = this.fTemplateArgs;
        if (templateArgs != null) {
            templateArgs = EvalID.instantiateArguments(templateArgs, tpMap, packOffset, within, point);
        }
        if ((fieldOwner = this.fFieldOwner) != null) {
            fieldOwner = fieldOwner.instantiate(tpMap, packOffset, within, maxdepth, point);
        }
        if ((nameOwner = this.fNameOwner) instanceof ICPPClassTemplate) {
            nameOwner = EvalID.resolveUnknown(CPPTemplates.createDeferredInstance((ICPPClassTemplate)nameOwner), tpMap, packOffset, within, point);
        } else if (nameOwner instanceof IType && (type = CPPTemplates.instantiateType((IType)((Object)nameOwner), tpMap, packOffset, within, point)) instanceof IBinding) {
            nameOwner = (IBinding)((Object)type);
        }
        if (fieldOwner instanceof IProblemBinding || nameOwner instanceof IProblemBinding) {
            return this;
        }
        if (templateArgs == this.fTemplateArgs && fieldOwner == this.fFieldOwner && nameOwner == this.fNameOwner) {
            return this;
        }
        if (nameOwner instanceof ICPPClassType && (eval = this.resolveName((ICPPClassType)nameOwner, templateArgs, point)) != null) {
            return eval;
        }
        return new EvalID(fieldOwner, nameOwner, this.fName, this.fAddressOf, this.fQualified, templateArgs);
    }

    private ICPPEvaluation resolveName(ICPPClassType nameOwner, ICPPTemplateArgument[] templateArgs, IASTNode point) {
        IBinding binding;
        LookupData data = new LookupData(this.fName, templateArgs, point);
        data.qualified = this.fQualified;
        try {
            CPPSemantics.lookup(data, nameOwner.getCompositeScope());
        }
        catch (DOMException dOMException) {}
        IBinding[] bindings = data.getFoundBindings();
        if (bindings.length > 1 && bindings[0] instanceof ICPPFunction) {
            ICPPFunction[] functions = new ICPPFunction[bindings.length];
            System.arraycopy(bindings, 0, functions, 0, bindings.length);
            return new EvalFunctionSet(new CPPFunctionSet(functions, templateArgs, null), this.fAddressOf);
        }
        IBinding iBinding = binding = bindings.length == 1 ? bindings[0] : null;
        if (binding instanceof IEnumerator) {
            return new EvalBinding(binding, null);
        }
        if (binding instanceof ICPPMember) {
            return new EvalMemberAccess(nameOwner, IASTExpression.ValueCategory.PRVALUE, binding, false);
        }
        if (binding instanceof CPPFunctionSet) {
            return new EvalFunctionSet((CPPFunctionSet)binding, this.fAddressOf);
        }
        return null;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = this.fFieldOwner.determinePackSize(tpMap);
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.fTemplateArgs;
        int n = this.fTemplateArgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fFieldOwner.referencesTemplateParameter();
    }
}

