/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;

public class CPPUnknownTypeScope
implements ICPPScope {
    private final IASTName fName;
    private final ICPPBinding fScopeBinding;

    public CPPUnknownTypeScope(IASTName name, ICPPBinding scopeBinding) {
        this.fName = name;
        this.fScopeBinding = scopeBinding;
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    public IASTNode getPhysicalNode() {
        return this.fName;
    }

    @Override
    public IName getScopeName() {
        return this.fName;
    }

    @Override
    public IScope getParent() throws DOMException {
        return this.fScopeBinding == null ? null : this.fScopeBinding.getScope();
    }

    @Override
    public IBinding[] find(String name) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        boolean type = false;
        boolean function = false;
        if (name.getPropertyInParent() == null) {
            type = true;
        } else {
            IASTName n = name;
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTTemplateId) {
                n = (IASTName)parent;
                parent = n.getParent();
            }
            if (parent instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
                if (qname.getLastName() != n) {
                    type = true;
                } else {
                    parent = qname.getParent();
                }
            }
            if (!type) {
                if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTConstructorChainInitializer) {
                    type = true;
                } else if (parent instanceof ICPPASTNamedTypeSpecifier) {
                    ICPPASTNamedTypeSpecifier nts = (ICPPASTNamedTypeSpecifier)parent;
                    type = nts.isTypename();
                } else if (parent instanceof ICPPASTUsingDeclaration) {
                    ICPPASTUsingDeclaration ud = (ICPPASTUsingDeclaration)parent;
                    type = ud.isTypename();
                }
                if (!type && parent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                    function = true;
                }
            }
        }
        int idx = type ? 0 : (function ? 1 : 2);
        IBinding result = this.getOrCreateBinding(name.getSimpleID(), idx);
        return result;
    }

    protected IBinding getOrCreateBinding(char[] name, int idx) {
        CPPUnknownBinding result = null;
        switch (idx) {
            case 0: {
                result = new CPPUnknownClass(this.fScopeBinding, name);
                break;
            }
            case 1: {
                result = new CPPUnknownFunction(this.fScopeBinding, name);
                break;
            }
            case 2: {
                result = new CPPUnknownBinding(this.fScopeBinding, name);
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public final IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        if (lookup.isPrefixLookup()) {
            ICPPDeferredClassInstance instance;
            IScope scope;
            if (this.fScopeBinding instanceof ICPPDeferredClassInstance && (scope = (instance = (ICPPDeferredClassInstance)this.fScopeBinding).getClassTemplate().getCompositeScope()) != null) {
                return scope.getBindings(lookup);
            }
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        IASTName lookupName = lookup.getLookupName();
        if (lookupName != null) {
            return new IBinding[]{this.getBinding(lookupName, lookup.isResolve(), lookup.getIncludedFiles())};
        }
        return new IBinding[]{this.getOrCreateBinding(lookup.getLookupKey(), 0)};
    }

    public ICPPBinding getScopeBinding() {
        return this.fScopeBinding;
    }

    public String toString() {
        return this.fName.toString();
    }
}

