/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.core.runtime.Assert;

public class CPPTemplateNonTypeArgument
implements ICPPTemplateArgument {
    private final ICPPEvaluation fEvaluation;

    public CPPTemplateNonTypeArgument(ICPPEvaluation evaluation) {
        Assert.isNotNull((Object)evaluation);
        this.fEvaluation = evaluation;
    }

    public CPPTemplateNonTypeArgument(IValue value, IType type) {
        this.fEvaluation = new EvalFixed(type, IASTExpression.ValueCategory.PRVALUE, value);
    }

    @Override
    public boolean isTypeValue() {
        return false;
    }

    @Override
    public boolean isNonTypeValue() {
        return true;
    }

    @Override
    public IType getTypeValue() {
        return null;
    }

    @Override
    public IValue getNonTypeValue() {
        return this.fEvaluation.getValue(null);
    }

    @Override
    public IType getTypeOfNonTypeValue() {
        return this.fEvaluation.getTypeOrFunctionSet(null);
    }

    @Override
    public boolean isPackExpansion() {
        return this.fEvaluation.getTypeOrFunctionSet(null) instanceof ICPPParameterPackType;
    }

    @Override
    public ICPPTemplateArgument getExpansionPattern() {
        IType t;
        IType type = this.fEvaluation.getTypeOrFunctionSet(null);
        if (type instanceof ICPPParameterPackType && (t = ((ICPPParameterPackType)type).getType()) != null) {
            CPPEvaluation evaluation;
            if (this.fEvaluation instanceof EvalFixed) {
                EvalFixed fixed = (EvalFixed)this.fEvaluation;
                evaluation = new EvalFixed(t, fixed.getValueCategory(), fixed.getValue());
            } else {
                evaluation = new EvalTypeId(t, this.fEvaluation);
            }
            return new CPPTemplateNonTypeArgument(evaluation);
        }
        return null;
    }

    @Override
    public boolean isSameValue(ICPPTemplateArgument arg) {
        return this.getNonTypeValue().equals(arg.getNonTypeValue());
    }

    public String toString() {
        return this.getNonTypeValue().toString();
    }

    public ICPPEvaluation getEvaluation() {
        return this.fEvaluation;
    }
}

