/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTArraySubscriptExpression
extends ASTNode
implements ICPPASTArraySubscriptExpression,
IASTAmbiguityParent {
    private ICPPASTExpression arrayExpression;
    private ICPPASTInitializerClause subscriptExp;
    private ICPPEvaluation evaluation;
    private IASTImplicitName[] implicitNames;

    public CPPASTArraySubscriptExpression() {
    }

    public CPPASTArraySubscriptExpression(IASTExpression arrayExpression, IASTInitializerClause operand) {
        this.setArrayExpression(arrayExpression);
        this.setArgument(operand);
    }

    @Override
    public CPPASTArraySubscriptExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTArraySubscriptExpression copy(IASTNode.CopyStyle style) {
        CPPASTArraySubscriptExpression copy = new CPPASTArraySubscriptExpression();
        copy.setArrayExpression(this.arrayExpression == null ? null : this.arrayExpression.copy(style));
        copy.setArgument(this.subscriptExp == null ? null : this.subscriptExp.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public ICPPASTExpression getArrayExpression() {
        return this.arrayExpression;
    }

    @Override
    public void setArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression != null) {
            if (!(expression instanceof ICPPASTExpression)) {
                throw new IllegalArgumentException(expression.getClass().getName());
            }
            expression.setParent(this);
            expression.setPropertyInParent(ARRAY);
        }
        this.arrayExpression = (ICPPASTExpression)expression;
    }

    @Override
    public ICPPASTInitializerClause getArgument() {
        return this.subscriptExp;
    }

    @Override
    public void setArgument(IASTInitializerClause arg) {
        this.assertNotFrozen();
        if (arg != null) {
            if (!(arg instanceof ICPPASTInitializerClause)) {
                throw new IllegalArgumentException(arg.getClass().getName());
            }
            arg.setParent(this);
            arg.setPropertyInParent(SUBSCRIPT);
        }
        this.subscriptExp = (ICPPASTInitializerClause)arg;
    }

    @Override
    @Deprecated
    public IASTExpression getSubscriptExpression() {
        if (this.subscriptExp instanceof IASTExpression) {
            return (IASTExpression)((Object)this.subscriptExp);
        }
        return null;
    }

    @Override
    @Deprecated
    public void setSubscriptExpression(IASTExpression expression) {
        this.setArgument(expression);
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null || overload instanceof CPPImplicitFunction) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            CPPASTImplicitName n1 = new CPPASTImplicitName(OverloadableOperator.BRACKET, (IASTNode)this);
            n1.setBinding(overload);
            n1.computeOperatorOffsets(this.arrayExpression, true);
            CPPASTImplicitName n2 = new CPPASTImplicitName(OverloadableOperator.BRACKET, (IASTNode)this);
            n2.setBinding(overload);
            n2.computeOperatorOffsets(this.subscriptExp, true);
            n2.setAlternate(true);
            this.implicitNames = new IASTImplicitName[]{n1, n2};
        }
        return this.implicitNames;
    }

    private ICPPFunction getOverload() {
        ICPPEvaluation eval = this.getEvaluation();
        if (eval instanceof EvalBinary) {
            return ((EvalBinary)eval).getOverload(this);
        }
        return null;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.arrayExpression != null && !this.arrayExpression.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        if (this.subscriptExp != null && !this.subscriptExp.accept(action)) {
            return false;
        }
        if (implicits != null && implicits.length > 0 && !implicits[1].accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.subscriptExp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.subscriptExp = (ICPPASTExpression)other;
        }
        if (child == this.arrayExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.arrayExpression = (ICPPASTExpression)other;
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.evaluation == null) {
            this.evaluation = this.computeEvaluation();
        }
        return this.evaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.arrayExpression == null || this.subscriptExp == null) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalBinary(127, this.arrayExpression.getEvaluation(), this.subscriptExp.getEvaluation());
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

