/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CFunctionType
implements IFunctionType,
ISerializableType {
    private final IType[] parameters;
    private final IType returnType;

    public CFunctionType(IType returnType, IType[] types) {
        this.returnType = returnType;
        this.parameters = types;
    }

    @Override
    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (o instanceof IFunctionType) {
            IFunctionType ft = (IFunctionType)o;
            IType[] fps = ft.getParameterTypes();
            if (fps.length != this.parameters.length) {
                return false;
            }
            if (!this.returnType.isSameType(ft.getReturnType())) {
                return false;
            }
            int i = 0;
            while (i < this.parameters.length) {
                if (!this.parameters[i].isSameType(fps[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public IType getReturnType() {
        return this.returnType;
    }

    @Override
    public IType[] getParameterTypes() {
        return this.parameters;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 5;
        int len = this.parameters.length & 0xFFFF;
        int codedLen = len * 16;
        if (codedLen < 128) {
            buffer.putByte((byte)(firstByte |= codedLen));
        } else {
            buffer.putByte((byte)(firstByte |= 0x80));
            buffer.putShort((short)len);
        }
        buffer.marshalType(this.returnType);
        int i = 0;
        while (i < len) {
            buffer.marshalType(this.parameters[i]);
            ++i;
        }
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int len = (firstByte & 0x80) != 0 ? buffer.getShort() : (firstByte & 0x7F) / 16;
        IType rt = buffer.unmarshalType();
        IType[] pars = new IType[len];
        int i = 0;
        while (i < pars.length) {
            pars[i] = buffer.unmarshalType();
            ++i;
        }
        return new CFunctionType(rt, pars);
    }
}

