/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceEnablement;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceChannelComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeChannelStateHandler
extends BaseControlViewHandler {
    protected Parameter fParam;

    protected abstract TraceEnablement getNewState();

    protected abstract void changeState(TraceDomainComponent var1, List<String> var2, IProgressMonitor var3) throws ExecutionException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fLock.lock();
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                Boolean bl = false;
                return bl;
            }
            final Parameter param = new Parameter(this.fParam);
            Job job = new Job(Messages.TraceControl_ChangeChannelStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    TraceControlComponent session = null;
                    try {
                        TraceDomainComponent kernelDomain = param.getKernelDomain();
                        List<TraceChannelComponent> kernelChannels = param.getKernelChannels();
                        if (kernelDomain != null) {
                            session = (TraceSessionComponent)kernelDomain.getParent();
                            ArrayList<String> channelNames = new ArrayList<String>();
                            for (TraceChannelComponent channel : kernelChannels) {
                                channelNames.add(channel.getName());
                            }
                            ChangeChannelStateHandler.this.changeState(kernelDomain, channelNames, monitor);
                            for (TraceChannelComponent channel : kernelChannels) {
                                channel.setState(ChangeChannelStateHandler.this.getNewState());
                            }
                        }
                        TraceDomainComponent ustDomain = param.getUstDomain();
                        List<TraceChannelComponent> ustChannels = param.getUstChannels();
                        if (ustDomain != null) {
                            if (session == null) {
                                session = (TraceSessionComponent)ustDomain.getParent();
                            }
                            ArrayList<String> channelNames = new ArrayList<String>();
                            for (TraceChannelComponent channel : ustChannels) {
                                channelNames.add(channel.getName());
                            }
                            ChangeChannelStateHandler.this.changeState(ustDomain, channelNames, monitor);
                            for (TraceChannelComponent channel : ustChannels) {
                                channel.setState(ChangeChannelStateHandler.this.getNewState());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    if (session != null) {
                        session.fireComponentChanged(session);
                    }
                    if (error != null) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_ChangeChannelStateFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceDomainComponent kernelDomain = null;
        TraceDomainComponent ustDomain = null;
        ArrayList<TraceChannelComponent> kernelChannels = new ArrayList<TraceChannelComponent>();
        ArrayList<TraceChannelComponent> ustChannels = new ArrayList<TraceChannelComponent>();
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            String sessionName = null;
            for (Object element : structered) {
                if (!(element instanceof TraceChannelComponent)) continue;
                TraceChannelComponent channel = (TraceChannelComponent)element;
                if (sessionName == null) {
                    sessionName = String.valueOf(channel.getSessionName());
                }
                if (!sessionName.equals(channel.getSessionName())) {
                    kernelChannels.clear();
                    ustChannels.clear();
                    break;
                }
                if (channel.getState() == this.getNewState()) continue;
                if (channel.isKernel()) {
                    kernelChannels.add(channel);
                    if (kernelDomain != null) continue;
                    kernelDomain = (TraceDomainComponent)channel.getParent();
                    continue;
                }
                ustChannels.add(channel);
                if (ustDomain != null) continue;
                ustDomain = (TraceDomainComponent)channel.getParent();
            }
        }
        boolean isEnabled = !kernelChannels.isEmpty() || !ustChannels.isEmpty();
        this.fLock.lock();
        try {
            if (isEnabled) {
                this.fParam = new Parameter(kernelDomain, ustDomain, kernelChannels, ustChannels);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    protected static class Parameter {
        protected final TraceDomainComponent fKernelDomain;
        protected final TraceDomainComponent fUstDomain;
        protected final List<TraceChannelComponent> fKernelChannels;
        protected final List<TraceChannelComponent> fUstChannels;

        public Parameter(TraceDomainComponent kernelDomain, TraceDomainComponent ustDomain, List<TraceChannelComponent> kernelChannels, List<TraceChannelComponent> ustChannels) {
            this.fKernelDomain = kernelDomain;
            this.fUstDomain = ustDomain;
            this.fKernelChannels = new ArrayList<TraceChannelComponent>();
            this.fKernelChannels.addAll(kernelChannels);
            this.fUstChannels = new ArrayList<TraceChannelComponent>();
            this.fUstChannels.addAll(ustChannels);
        }

        public Parameter(Parameter other) {
            this(other.fKernelDomain, other.fUstDomain, other.fKernelChannels, other.fUstChannels);
        }

        public TraceDomainComponent getKernelDomain() {
            return this.fKernelDomain;
        }

        public TraceDomainComponent getUstDomain() {
            return this.fUstDomain;
        }

        public List<TraceChannelComponent> getKernelChannels() {
            return this.fKernelChannels;
        }

        public List<TraceChannelComponent> getUstChannels() {
            return this.fUstChannels;
        }
    }
}

