/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.Messages;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.GDBBackendCLIProcess;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControlDMContext;
import org.eclipse.cdt.dsf.gdb.service.command.GdbCommandTimeoutManager;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMIBackend2;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.mi.service.command.AbstractMIControl;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.IEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.MIRunControlEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.osgi.framework.BundleContext;

public class GDBControl
extends AbstractMIControl
implements IGDBControl {
    private static final int STATUS_CODE_COMMAND_TIMED_OUT = 20100;
    private GDBControlDMContext fControlDmc;
    private IGDBBackend fMIBackend;
    private IEventProcessor fMIEventProcessor;
    private IEventProcessor fCLICommandProcessor;
    private AbstractCLIProcess fCLIProcess;
    private GdbCommandTimeoutManager fCommandTimeoutManager;
    private GdbCommandTimeoutManager.ICommandTimeoutListener fTimeoutListener = new TimeoutListener();
    private final List<String> fFeatures = new ArrayList<String>();
    private Sequence fInitializationSequence;
    private boolean fInitialized = false;
    private boolean fTerminated;

    public GDBControl(DsfSession session, ILaunchConfiguration config, CommandFactory factory) {
        this(session, false, config, factory);
    }

    protected GDBControl(DsfSession session, boolean useThreadAndFrameOptions, ILaunchConfiguration config, CommandFactory factory) {
        super(session, useThreadAndFrameOptions, factory);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBControl.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fMIBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fControlDmc = new GDBControlDMContext(this.getSession().getId(), this.getId());
        this.getExecutor().execute((Runnable)this.getStartupSequence(requestMonitor));
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        this.getExecutor().execute((Runnable)this.getShutdownSequence(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                GDBControl.super.shutdown(requestMonitor);
            }
        }));
    }

    public String getId() {
        return this.fMIBackend.getId();
    }

    @Override
    public MIControlDMContext getControlDMContext() {
        return this.fControlDmc;
    }

    public ICommandControlService.ICommandControlDMContext getContext() {
        return this.fControlDmc;
    }

    @Override
    public void terminate(final RequestMonitor rm) {
        IMIRunControl runControl;
        if (this.fTerminated) {
            rm.done();
            return;
        }
        this.fTerminated = true;
        if (this.fInitializationSequence != null) {
            this.fInitializationSequence.getRequestMonitor().cancel();
        }
        if ((runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class)) != null && !runControl.isTargetAcceptingCommands()) {
            this.fMIBackend.interrupt();
        }
        final ScheduledFuture forceQuitTask = this.getExecutor().schedule((Runnable)new DsfRunnable(){

            public void run() {
                GDBControl.this.fMIBackend.destroy();
                rm.done();
            }

            protected boolean isExecutionRequired() {
                return false;
            }
        }, 2L, TimeUnit.SECONDS);
        this.queueCommand(this.getCommandFactory().createMIGDBExit(this.fControlDmc), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleCompleted() {
                if (this.isSuccess()) {
                    forceQuitTask.cancel(false);
                    rm.done();
                }
            }
        });
    }

    @Override
    public AbstractCLIProcess getCLIProcess() {
        return this.fCLIProcess;
    }

    @Override
    public void setTracingStream(OutputStream tracingStream) {
        this.setMITracingStream(tracingStream);
    }

    @Override
    public void setEnvironment(Properties props, boolean clear, RequestMonitor rm) {
        int count = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        if (clear) {
            ++count;
            this.queueCommand(this.getCommandFactory().createCLIUnsetEnv(this.getContext()), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            ++count;
            String name = (String)property.getKey();
            String value = (String)property.getValue();
            this.queueCommand(this.getCommandFactory().createMIGDBSetEnv(this.getContext(), name, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        countingRm.setDoneCount(count);
    }

    @Override
    public void completeInitialization(final RequestMonitor rm) {
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        Map attributes = null;
        try {
            attributes = launch.getLaunchConfiguration().getAttributes();
        }
        catch (CoreException coreException) {}
        NullProgressMonitor monitor = rm instanceof RequestMonitorWithProgress ? ((RequestMonitorWithProgress)rm).getProgressMonitor() : new NullProgressMonitor();
        RequestMonitorWithProgress progressRm = new RequestMonitorWithProgress((Executor)this.getExecutor(), (IProgressMonitor)monitor){

            protected void handleCompleted() {
                GDBControl.this.fInitializationSequence = null;
                GDBControl.this.fInitialized = true;
                if (!this.isCanceled()) {
                    rm.setStatus(this.getStatus());
                } else {
                    rm.cancel();
                }
                rm.done();
            }
        };
        this.fInitializationSequence = this.getCompleteInitializationSequence(attributes, progressRm);
        ImmediateExecutor.getInstance().execute((Runnable)this.fInitializationSequence);
    }

    protected Sequence getCompleteInitializationSequence(Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        return new FinalLaunchSequence(this.getSession(), attributes, rm);
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.stopCommandProcessing();
        IGDBProcesses procService = (IGDBProcesses)this.getServicesTracker().getService(IGDBProcesses.class);
        if (procService != null) {
            IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
            this.getSession().dispatchEvent((Object)new MIProcesses.ContainerExitedDMEvent(processContainerDmc), this.getProperties());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (e.getState() == IMIBackend.State.TERMINATED && e.getBackendId().equals(this.fMIBackend.getId())) {
            this.getSession().dispatchEvent((Object)new GDBControlShutdownDMEvent(this.fControlDmc), this.getProperties());
        }
    }

    @Override
    public List<String> getFeatures() {
        return this.fFeatures;
    }

    @Override
    public void enablePrettyPrintingForMIVariableObjects(RequestMonitor rm) {
        rm.done();
    }

    @Override
    public void setPrintPythonErrors(boolean enabled, RequestMonitor rm) {
        rm.done();
    }

    protected Sequence getStartupSequence(RequestMonitor requestMonitor) {
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new CommandMonitoringStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandProcessorsStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandTimeoutStep(InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(InitializationShutdownStep.Direction.INITIALIZING)};
        return new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
    }

    protected Sequence getShutdownSequence(RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandTimeoutStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandProcessorsStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandMonitoringStep(InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        return new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
    }

    protected IEventProcessor createCLIEventProcessor(ICommandControlService connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        return new CLIEventProcessor(connection, controlDmc);
    }

    protected IEventProcessor createMIRunControlEventProcessor(AbstractMIControl connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        return new MIRunControlEventProcessor(connection, controlDmc);
    }

    protected void setFeatures(List<String> features) {
        this.fFeatures.clear();
        this.fFeatures.addAll(features);
    }

    protected GdbCommandTimeoutManager createCommandTimeoutManager(ICommandControl commandControl) {
        GdbCommandTimeoutManager manager = new GdbCommandTimeoutManager(commandControl);
        manager.initialize();
        return manager;
    }

    @ConfinedToDsfExecutor(value="this.getExecutor()")
    protected void commandTimedOut(ICommandToken token) {
        String commandText = token.getCommand().toString();
        if (commandText.endsWith("\n")) {
            commandText = commandText.substring(0, commandText.length() - 1);
        }
        String errorMessage = String.format("Command '%s' is timed out", commandText);
        this.commandFailed(token, 20100, errorMessage);
        if (this.isInitialized()) {
            this.terminate(new RequestMonitor((Executor)this.getExecutor(), null){

                protected void handleErrorOrWarning() {
                    GdbPlugin.getDefault().getLog().log(this.getStatus());
                    super.handleErrorOrWarning();
                }
            });
            Status status = new Status(4, "org.eclipse.cdt.dsf.gdb", 20001, String.format(Messages.GDBControl_Session_is_terminated, errorMessage), null);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (statusHandler != null) {
                try {
                    statusHandler.handleStatus((IStatus)status, null);
                }
                catch (CoreException e) {
                    GdbPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
        }
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected class CommandMonitoringStep
    extends InitializationShutdownStep {
        CommandMonitoringStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        protected void initialize(RequestMonitor requestMonitor) {
            InputStream errorStream = null;
            if (GDBControl.this.fMIBackend instanceof IMIBackend2) {
                errorStream = ((IMIBackend2)((Object)GDBControl.this.fMIBackend)).getMIErrorStream();
            }
            GDBControl.this.startCommandProcessing(GDBControl.this.fMIBackend.getMIInputStream(), GDBControl.this.fMIBackend.getMIOutputStream(), errorStream);
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.stopCommandProcessing();
            requestMonitor.done();
        }
    }

    protected class CommandProcessorsStep
    extends InitializationShutdownStep {
        CommandProcessorsStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            try {
                GDBControl.this.fCLIProcess = new GDBBackendCLIProcess(GDBControl.this, GDBControl.this.fMIBackend);
            }
            catch (IOException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Failed to create CLI Process", (Throwable)e));
                requestMonitor.done();
                return;
            }
            GDBControl.this.fCLICommandProcessor = GDBControl.this.createCLIEventProcessor(GDBControl.this, GDBControl.this.fControlDmc);
            GDBControl.this.fMIEventProcessor = GDBControl.this.createMIRunControlEventProcessor(GDBControl.this, GDBControl.this.fControlDmc);
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.fCLICommandProcessor.dispose();
            GDBControl.this.fMIEventProcessor.dispose();
            GDBControl.this.fCLIProcess.dispose();
            requestMonitor.done();
        }
    }

    protected class CommandTimeoutStep
    extends InitializationShutdownStep {
        CommandTimeoutStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.fCommandTimeoutManager = GDBControl.this.createCommandTimeoutManager((ICommandControl)GDBControl.this);
            if (GDBControl.this.fCommandTimeoutManager != null) {
                GDBControl.this.fCommandTimeoutManager.addCommandTimeoutListener(GDBControl.this.fTimeoutListener);
            }
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            if (GDBControl.this.fCommandTimeoutManager != null) {
                GDBControl.this.fCommandTimeoutManager.removeCommandTimeoutListener(GDBControl.this.fTimeoutListener);
                GDBControl.this.fCommandTimeoutManager.dispose();
            }
            requestMonitor.done();
        }
    }

    private static class GDBControlInitializedDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlInitializedDMEvent {
        public GDBControlInitializedDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    private static class GDBControlShutdownDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlShutdownDMEvent {
        public GDBControlShutdownDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class InitializationShutdownStep
    extends Sequence.Step {
        private Direction fDirection;

        public InitializationShutdownStep(Direction direction) {
            this.fDirection = direction;
        }

        public final void execute(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.initialize(requestMonitor);
            } else {
                this.shutdown(requestMonitor);
            }
        }

        public final void rollBack(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.shutdown(requestMonitor);
            } else {
                super.rollBack(requestMonitor);
            }
        }

        protected void initialize(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        public static enum Direction {
            INITIALIZING,
            SHUTTING_DOWN;

        }
    }

    protected class RegisterStep
    extends InitializationShutdownStep {
        RegisterStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.getSession().addServiceEventListener((Object)GDBControl.this, null);
            GDBControl.this.register(new String[]{ICommandControl.class.getName(), ICommandControlService.class.getName(), IMICommandControl.class.getName(), AbstractMIControl.class.getName(), IGDBControl.class.getName()}, new Hashtable());
            GDBControl.this.getSession().dispatchEvent((Object)new GDBControlInitializedDMEvent(GDBControl.this.fControlDmc), GDBControl.this.getProperties());
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.unregister();
            GDBControl.this.getSession().removeServiceEventListener((Object)GDBControl.this);
            requestMonitor.done();
        }
    }

    private class TimeoutListener
    implements GdbCommandTimeoutManager.ICommandTimeoutListener {
        private TimeoutListener() {
        }

        @Override
        public void commandTimedOut(final ICommandToken token) {
            GDBControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    GDBControl.this.commandTimedOut(token);
                }
            });
        }
    }
}

