/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;
import org.eclipse.cdt.managedbuilder.language.settings.providers.ToolchainBuiltinSpecsDetector;
import org.eclipse.core.runtime.CoreException;

public class GCCBuiltinSpecsDetector
extends ToolchainBuiltinSpecsDetector
implements ILanguageSettingsEditableProvider {
    private static final String GCC_TOOLCHAIN_ID = "cdt.managedbuild.toolchain.gnu.base";
    private State state = State.NONE;
    private static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] optionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("#include \"(\\S.*)\"", "$1", 7), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("#include <(\\S.*)>", "$1", 3), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("#framework <(\\S.*)>", "$1", 67), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("#define\\s+(\\S*\\(.*?\\))\\s*(.*)", "$1", "$2", 3), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("#define\\s+(\\S*)\\s*(\\S*)", "$1", "$2", 3)};

    @Override
    protected String getToolchainId() {
        return GCC_TOOLCHAIN_ID;
    }

    @Override
    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers() {
        return optionParsers;
    }

    private List<String> makeList(String line) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(line);
        return list;
    }

    @Override
    protected List<String> parseOptions(String line) {
        if ((line = line.trim()).startsWith("#define")) {
            return this.makeList(line);
        }
        if (line.equals("#include \"...\" search starts here:")) {
            this.state = State.EXPECTING_LOCAL_INCLUDE;
        } else if (line.equals("#include <...> search starts here:")) {
            this.state = State.EXPECTING_SYSTEM_INCLUDE;
        } else if (line.startsWith("End of search list.")) {
            this.state = State.NONE;
        } else if (line.equals("Framework search starts here:")) {
            this.state = State.EXPECTING_FRAMEWORKS;
        } else if (line.startsWith("End of framework search list.")) {
            this.state = State.NONE;
        } else {
            if (this.state == State.EXPECTING_LOCAL_INCLUDE) {
                line = "#include \"" + line + "\"";
                return this.makeList(line);
            }
            String frameworkIndicator = "(framework directory)";
            if (this.state == State.EXPECTING_SYSTEM_INCLUDE) {
                line = line.contains(frameworkIndicator) ? "#framework <" + line.replace(frameworkIndicator, "").trim() + ">" : "#include <" + line + ">";
                return this.makeList(line);
            }
            if (this.state == State.EXPECTING_FRAMEWORKS) {
                line = "#framework <" + line.replace(frameworkIndicator, "").trim() + ">";
                return this.makeList(line);
            }
        }
        return null;
    }

    @Override
    public void startup(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker) throws CoreException {
        super.startup(cfgDescription, cwdTracker);
        this.state = State.NONE;
    }

    @Override
    public void shutdown() {
        this.state = State.NONE;
        super.shutdown();
    }

    @Override
    public GCCBuiltinSpecsDetector cloneShallow() throws CloneNotSupportedException {
        return (GCCBuiltinSpecsDetector)super.cloneShallow();
    }

    public GCCBuiltinSpecsDetector clone() throws CloneNotSupportedException {
        return (GCCBuiltinSpecsDetector)super.clone();
    }

    private static enum State {
        NONE,
        EXPECTING_LOCAL_INCLUDE,
        EXPECTING_SYSTEM_INCLUDE,
        EXPECTING_FRAMEWORKS;

    }
}

