/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIErrorEvent
extends MIStoppedEvent {
    String msg = "";
    String log = "";
    MIOOBRecord[] oobs;

    public MIErrorEvent(MISession source, MIResultRecord rr, MIOOBRecord[] o) {
        super(source, rr);
        this.oobs = o;
        this.parse();
    }

    public String getMessage() {
        return this.msg;
    }

    public String getLogMessage() {
        return this.log;
    }

    @Override
    void parse() {
        MIResultRecord rr = this.getMIResultRecord();
        if (rr != null) {
            MIResult[] results = rr.getMIResults();
            if (results != null) {
                int i = 0;
                while (i < results.length) {
                    String var = results[i].getVariable();
                    MIValue value = results[i].getMIValue();
                    String str = "";
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getString();
                    }
                    if (var.equals("msg")) {
                        this.msg = str;
                    }
                    ++i;
                }
            }
            if (this.oobs != null) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.oobs.length) {
                    if (this.oobs[i] instanceof MILogStreamOutput) {
                        MIStreamRecord o = (MIStreamRecord)this.oobs[i];
                        sb.append(o.getString());
                    }
                    ++i;
                }
                this.log = sb.toString();
            }
        }
    }
}

