/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui.dialogs;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.dialogs.EnhancedWizardDialog;
import org.eclipse.mylyn.commons.ui.dialogs.IValidatable;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatableWizardDialog
extends EnhancedWizardDialog {
    private static final String VALIDATE_BUTTON_KEY = "validate";
    private Button validateServerButton;
    private static final int VALIDATE_BUTTON_ID = 2000;

    public ValidatableWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.setHelpAvailable(false);
    }

    @Override
    protected void createExtraButtons(Composite composite) {
        this.validateServerButton = this.createButton(composite, 2000, Messages.ValidatableWizardDialog_Validate_Button_Label, false);
        this.validateServerButton.setImage(CommonImages.getImage(CommonImages.VALIDATE));
        this.validateServerButton.setVisible(false);
        this.setButtonLayoutData(this.validateServerButton);
    }

    @Override
    public void updateExtraButtons() {
        IValidatable validatable = this.getValidatablePage();
        if (validatable != null && validatable.needsValidation()) {
            if (!this.validateServerButton.isVisible()) {
                this.validateServerButton.setVisible(true);
            }
            this.validateServerButton.setEnabled(validatable.canValidate());
        } else if (this.validateServerButton != null && this.validateServerButton.isVisible()) {
            this.validateServerButton.setVisible(false);
        }
    }

    private IValidatable getValidatablePage() {
        IValidatable validatable = null;
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof IValidatable) {
            validatable = (IValidatable)currentPage;
        } else if (currentPage instanceof IAdaptable) {
            validatable = (IValidatable)((IAdaptable)currentPage).getAdapter(IValidatable.class);
        }
        return validatable;
    }

    @Override
    protected boolean handleExtraButtonPressed(int buttonId) {
        IValidatable validatable;
        if (buttonId == 2000 && (validatable = this.getValidatablePage()) != null) {
            validatable.validate();
            return true;
        }
        return false;
    }

    @Override
    protected HashMap<String, Boolean> saveAndSetEnabledStateMylyn() {
        HashMap<String, Boolean> savedEnabledState = null;
        if (this.getShell() != null) {
            savedEnabledState = new HashMap<String, Boolean>();
            if (this.validateServerButton != null && this.validateServerButton.getShell() == this.getShell()) {
                savedEnabledState.put(VALIDATE_BUTTON_KEY, this.validateServerButton.getEnabled());
                this.validateServerButton.setEnabled(false);
            }
        }
        return savedEnabledState;
    }

    @Override
    protected void restoreEnabledStateMylyn(HashMap<String, Boolean> savedEnabledState) {
        if (savedEnabledState != null) {
            Boolean savedValidateEnabledState = savedEnabledState.get(VALIDATE_BUTTON_KEY);
            if (this.validateServerButton != null && savedValidateEnabledState != null) {
                this.validateServerButton.setEnabled(savedValidateEnabledState.booleanValue());
            }
        }
    }
}

