/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.AbstractVMProviderActionDelegate;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;

public class ConnectActionDelegate
extends AbstractVMProviderActionDelegate {
    public void run(IAction action) {
        if (action.isEnabled()) {
            action.setEnabled(false);
            IConnect connectCommand = this.getConnectCommand();
            if (connectCommand != null) {
                connectCommand.connect(null);
            }
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        this.updateEnablement();
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        this.updateEnablement();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean enabled = false;
        IConnect connectCommand = this.getConnectCommand();
        if (connectCommand != null) {
            enabled = connectCommand.canConnect();
        }
        this.getAction().setEnabled(enabled);
    }

    private IConnect getConnectCommand() {
        IConnect command = null;
        Object element = this.getViewerInput();
        if (element instanceof IDMVMContext) {
            IDMVMContext dmc = (IDMVMContext)element;
            command = (IConnect)dmc.getAdapter(IConnect.class);
        } else if (element instanceof GdbLaunch) {
            GdbLaunch launch = (GdbLaunch)element;
            command = (IConnect)launch.getSession().getModelAdapter(IConnect.class);
        }
        return command;
    }
}

