/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExpressionExtractor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.StatementExtractor;
import org.eclipse.text.edits.TextEditGroup;

public abstract class FunctionExtractor {
    public static FunctionExtractor createFor(List<IASTNode> list) {
        if (list.get(0) instanceof IASTExpression) {
            return new ExpressionExtractor();
        }
        return new StatementExtractor();
    }

    public abstract boolean canChooseReturnValue();

    public abstract void constructMethodBody(IASTCompoundStatement var1, List<IASTNode> var2, List<NameInformation> var3, ASTRewrite var4, TextEditGroup var5);

    public abstract IASTDeclSpecifier determineReturnType(IASTNode var1, NameInformation var2);

    public abstract IASTNode createReturnAssignment(IASTNode var1, IASTExpressionStatement var2, IASTExpression var3);

    protected boolean hasPointerReturnType(IASTNode node) {
        return false;
    }

    IASTStandardFunctionDeclarator createFunctionDeclarator(IASTName name, IASTStandardFunctionDeclarator functionDeclarator, NameInformation returnVariable, List<IASTNode> nodesToWrite, Collection<NameInformation> allUsedNames, INodeFactory nodeFactory) {
        IASTStandardFunctionDeclarator declarator = nodeFactory.newFunctionDeclarator(name);
        if (functionDeclarator instanceof ICPPASTFunctionDeclarator && declarator instanceof ICPPASTFunctionDeclarator && ((ICPPASTFunctionDeclarator)functionDeclarator).isConst()) {
            ((ICPPASTFunctionDeclarator)declarator).setConst(true);
        }
        if (returnVariable != null) {
            IASTPointerOperator[] pointers;
            IASTDeclarator decl = returnVariable.getDeclarator();
            IASTPointerOperator[] iASTPointerOperatorArray = pointers = decl.getPointerOperators();
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator operator = iASTPointerOperatorArray[n2];
                declarator.addPointerOperator(operator.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
        }
        for (IASTParameterDeclaration param : this.getParameterDeclarations(allUsedNames, nodeFactory)) {
            declarator.addParameterDeclaration(param);
        }
        if (this.hasPointerReturnType(nodesToWrite.get(0))) {
            declarator.addPointerOperator((IASTPointerOperator)nodeFactory.newPointer());
        }
        return declarator;
    }

    public List<IASTParameterDeclaration> getParameterDeclarations(Collection<NameInformation> parameterNames, INodeFactory nodeFactory) {
        ArrayList<IASTParameterDeclaration> result = new ArrayList<IASTParameterDeclaration>(parameterNames.size());
        for (NameInformation param : parameterNames) {
            result.add(param.getParameterDeclaration(nodeFactory));
        }
        return result;
    }

    protected static void adjustParameterReferences(IASTNode node, final Map<IASTName, NameInformation> changedParameters, final INodeFactory nodeFactory, final ASTRewrite rewrite, final TextEditGroup group) {
        if (changedParameters.isEmpty()) {
            return;
        }
        node.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                NameInformation param = (NameInformation)changedParameters.get(name.getOriginalNode());
                if (param != null) {
                    IASTName newName = null;
                    if (param.isRenamed()) {
                        newName = nodeFactory.newName(param.getNewName().toCharArray());
                    }
                    if (param.getIndirection() == NameInformation.Indirection.POINTER && name.getPropertyInParent() == IASTIdExpression.ID_NAME) {
                        IASTIdExpression idExp = (IASTIdExpression)name.getParent();
                        if (idExp.getPropertyInParent() == IASTFieldReference.FIELD_OWNER && !((IASTFieldReference)idExp.getParent()).isPointerDereference()) {
                            IASTFieldReference dotRef = (IASTFieldReference)idExp.getParent();
                            IASTFieldReference arrowRef = dotRef.copy(IASTNode.CopyStyle.withLocations);
                            arrowRef.setIsPointerDereference(true);
                            if (newName != null) {
                                idExp = (IASTIdExpression)arrowRef.getFieldOwner();
                                idExp.setName(newName);
                            }
                            rewrite.replace((IASTNode)dotRef, (IASTNode)arrowRef, group);
                        } else {
                            IASTIdExpression newIdExp = idExp.copy(IASTNode.CopyStyle.withLocations);
                            IASTUnaryExpression starExp = nodeFactory.newUnaryExpression(4, (IASTExpression)newIdExp);
                            if (newName != null) {
                                newIdExp.setName(newName);
                            }
                            rewrite.replace((IASTNode)idExp, (IASTNode)starExp, group);
                        }
                    } else if (newName != null) {
                        rewrite.replace((IASTNode)name, (IASTNode)newName, group);
                    }
                }
                return super.visit(name);
            }
        });
    }

    protected static Map<IASTName, NameInformation> getChangedParameterReferences(List<NameInformation> parameters) {
        HashMap<IASTName, NameInformation> referenceLookupMap = new HashMap<IASTName, NameInformation>();
        for (NameInformation param : parameters) {
            if (!param.isRenamed() && param.getIndirection() != NameInformation.Indirection.POINTER) continue;
            for (IASTName name : param.getReferencesInSelection()) {
                referenceLookupMap.put(name, param);
            }
        }
        return referenceLookupMap;
    }
}

