/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class BuildLogPreferencePage
extends PropertyPage
implements ICOptionContainer {
    private boolean isProjectLevel;
    private Button enableLoggingCheckbox;
    private Button browseButton;
    private Text logLocationText;
    private Label logLocationLabel;

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        boolean bl = this.isProjectLevel = project != null;
        if (this.isProjectLevel) {
            BuildConsoleManager consoleManager = this.getConsoleManager();
            org.osgi.service.prefs.Preferences prefs = consoleManager.getBuildLogPreferences(project);
            Composite contents = ControlFactory.createCompositeEx(parent, 3, 1808);
            ((GridLayout)contents.getLayout()).makeColumnsEqualWidth = false;
            ControlFactory.createEmptySpace(contents, 3);
            this.enableLoggingCheckbox = ControlFactory.createCheckBox(contents, PreferencesMessages.BuildLogPreferencePage_EnableLogging);
            ((GridData)this.enableLoggingCheckbox.getLayoutData()).horizontalSpan = 2;
            boolean keepLog = prefs.getBoolean("keepLog", true);
            this.enableLoggingCheckbox.setSelection(keepLog);
            this.enableLoggingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuildLogPreferencePage.this.updateEnablements();
                }
            });
            ControlFactory.createEmptySpace(contents, 3);
            this.logLocationLabel = ControlFactory.createLabel(contents, PreferencesMessages.BuildLogPreferencePage_LogLocation);
            ((GridData)this.logLocationLabel.getLayoutData()).grabExcessHorizontalSpace = false;
            this.logLocationText = ControlFactory.createTextField(contents, 2052);
            String logLocation = prefs.get("logLocation", consoleManager.getDefaultConsoleLogLocation(project));
            this.logLocationText.setText(logLocation);
            this.logLocationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
            this.browseButton = ControlFactory.createPushButton(contents, PreferencesMessages.BuildLogPreferencePage_Browse);
            ((GridData)this.browseButton.getLayoutData()).horizontalAlignment = 3;
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog dialog = new FileDialog(BuildLogPreferencePage.this.getShell(), 0);
                    dialog.setText(PreferencesMessages.BuildLogPreferencePage_ChooseLogFile);
                    String fileName = BuildLogPreferencePage.this.logLocationText.getText();
                    IPath logFolder = new Path(fileName).removeLastSegments(1);
                    dialog.setFilterPath(logFolder.toOSString());
                    String chosenFile = dialog.open();
                    if (chosenFile != null) {
                        BuildLogPreferencePage.this.logLocationText.setText(chosenFile);
                    }
                }
            });
            this.updateEnablements();
        }
        return parent;
    }

    protected void performDefaults() {
        if (this.isProjectLevel) {
            IProject project = this.getProject();
            BuildConsoleManager consoleManager = this.getConsoleManager();
            org.osgi.service.prefs.Preferences prefs = consoleManager.getBuildLogPreferences(project);
            prefs.put("logLocation", consoleManager.getDefaultConsoleLogLocation(project));
            prefs.putBoolean("keepLog", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                CUIPlugin.log(e);
            }
            this.logLocationText.setText(prefs.get("logLocation", consoleManager.getDefaultConsoleLogLocation(project)));
            this.enableLoggingCheckbox.setSelection(prefs.getBoolean("keepLog", true));
            this.updateEnablements();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.isProjectLevel) {
            BuildConsoleManager consoleManager = this.getConsoleManager();
            org.osgi.service.prefs.Preferences prefs = consoleManager.getBuildLogPreferences(this.getProject());
            prefs.put("logLocation", this.logLocationText.getText());
            prefs.putBoolean("keepLog", this.enableLoggingCheckbox.getSelection());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                CUIPlugin.log(e);
            }
        }
        return true;
    }

    @Override
    public IProject getProject() {
        IProject project = null;
        IAdaptable elem = this.getElement();
        if (elem instanceof IProject) {
            project = (IProject)elem;
        } else if (elem != null) {
            project = (IProject)elem.getAdapter(IProject.class);
        }
        return project;
    }

    private BuildConsoleManager getConsoleManager() {
        return (BuildConsoleManager)CUIPlugin.getDefault().getConsoleManager();
    }

    @Override
    @Deprecated
    public Preferences getPreferences() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateContainer() {
    }

    private void updateEnablements() {
        boolean isLoggingEnabled = this.enableLoggingCheckbox.getSelection();
        this.logLocationLabel.setEnabled(isLoggingEnabled);
        this.logLocationText.setEnabled(isLoggingEnabled);
        this.browseButton.setEnabled(isLoggingEnabled);
    }
}

