/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.ConstructedCEditorMessages;
import org.eclipse.cdt.internal.ui.editor.GotoAnnotationAction;
import org.eclipse.cdt.internal.ui.editor.ToggleMarkOccurrencesAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class CEditorActionContributor
extends TextEditorActionContributor {
    private RetargetTextEditorAction fContentAssist;
    private RetargetTextEditorAction fContextInformation;
    private TogglePresentationAction fTogglePresentation;
    private GotoAnnotationAction fPreviousAnnotation;
    private GotoAnnotationAction fNextAnnotation;
    private RetargetTextEditorAction fGotoMatchingBracket;
    private RetargetTextEditorAction fGotoNextBookmark;
    private RetargetTextEditorAction fGotoNextMemberAction;
    private RetargetTextEditorAction fGotoPreviousMemberAction;
    private RetargetTextEditorAction fToggleInsertModeAction;
    private RetargetTextEditorAction fShowOutline;
    private RetargetTextEditorAction fToggleSourceHeader;
    private ToggleMarkOccurrencesAction fToggleMarkOccurrencesAction;
    private RetargetTextEditorAction fFindWord;
    private RetargetTextEditorAction fExpandSelectionToEnclosing;
    private RetargetTextEditorAction fExpandSelectionToNext;
    private RetargetTextEditorAction fExpandSelectionToPrevious;
    private RetargetTextEditorAction fExpandSelectionToHistory;

    public CEditorActionContributor() {
        ResourceBundle bundle = ConstructedCEditorMessages.getResourceBundle();
        this.fContentAssist = new RetargetTextEditorAction(bundle, "ContentAssistProposal.");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fContextInformation = new RetargetTextEditorAction(bundle, "ContentAssistContextInformation.");
        this.fContextInformation.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.fTogglePresentation = new TogglePresentationAction();
        this.fToggleMarkOccurrencesAction = new ToggleMarkOccurrencesAction();
        this.fPreviousAnnotation = new GotoAnnotationAction("PreviousAnnotation.", false);
        this.fNextAnnotation = new GotoAnnotationAction("NextAnnotation.", true);
        this.fGotoMatchingBracket = new RetargetTextEditorAction(bundle, "GotoMatchingBracket.");
        this.fGotoMatchingBracket.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.matching.bracket");
        this.fGotoNextBookmark = new RetargetTextEditorAction(bundle, "GotoNextBookmark.");
        this.fGotoNextBookmark.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.next.bookmark");
        this.fGotoNextMemberAction = new RetargetTextEditorAction(bundle, "GotoNextMember.");
        this.fGotoNextMemberAction.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.next.member");
        this.fGotoPreviousMemberAction = new RetargetTextEditorAction(bundle, "GotoPreviousMember.");
        this.fGotoPreviousMemberAction.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.prev.member");
        this.fToggleInsertModeAction = new RetargetTextEditorAction(bundle, "ToggleInsertMode.", 2);
        this.fToggleInsertModeAction.setActionDefinitionId("org.eclipse.ui.edit.text.toggleInsertMode");
        this.fShowOutline = new RetargetTextEditorAction(bundle, "OpenOutline.");
        this.fShowOutline.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.outline");
        this.fToggleSourceHeader = new RetargetTextEditorAction(bundle, "ToggleSourceHeader.");
        this.fToggleSourceHeader.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.toggle.source.header");
        this.fFindWord = new RetargetTextEditorAction(bundle, "FindWord.");
        this.fFindWord.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.find.word");
        this.fExpandSelectionToEnclosing = new RetargetTextEditorAction(bundle, "StructureSelectEnclosing.");
        this.fExpandSelectionToEnclosing.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.enclosing");
        this.fExpandSelectionToNext = new RetargetTextEditorAction(bundle, "StructureSelectNext.");
        this.fExpandSelectionToNext.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.next");
        this.fExpandSelectionToPrevious = new RetargetTextEditorAction(bundle, "StructureSelectPrevious.");
        this.fExpandSelectionToPrevious.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.previous");
        this.fExpandSelectionToHistory = new RetargetTextEditorAction(bundle, "StructureSelectHistory.");
        this.fExpandSelectionToHistory.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.last");
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager navigateMenu;
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("group.assist", (IAction)this.fContentAssist);
            editMenu.appendToGroup("group.assist", (IAction)this.fContextInformation);
            editMenu.prependToGroup("find.ext", (IAction)this.fFindWord);
            editMenu.appendToGroup("additions", (IAction)this.fToggleInsertModeAction);
            MenuManager structureSelection = new MenuManager(CEditorMessages.CEditorActionContributor_ExpandSelectionMenu_label, "expandSelection");
            editMenu.insertAfter(ITextEditorActionConstants.SELECT_ALL, (IContributionItem)structureSelection);
            structureSelection.add((IAction)this.fExpandSelectionToEnclosing);
            structureSelection.add((IAction)this.fExpandSelectionToNext);
            structureSelection.add((IAction)this.fExpandSelectionToPrevious);
            structureSelection.add((IAction)this.fExpandSelectionToHistory);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("open.ext", (IAction)this.fToggleSourceHeader);
            navigateMenu.appendToGroup("show.ext", (IAction)this.fShowOutline);
            IMenuManager gotoMenu = navigateMenu.findMenuUsingPath("goTo");
            if (gotoMenu != null) {
                gotoMenu.add((IContributionItem)new Separator("additions2"));
                gotoMenu.appendToGroup("additions2", (IAction)this.fGotoPreviousMemberAction);
                gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextMemberAction);
                gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
                gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextBookmark);
            }
        }
    }

    public void init(IActionBars bars) {
        super.init(bars);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.edit.text.c.toggleMarkOccurrences", (IAction)this.fToggleMarkOccurrencesAction);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fTogglePresentation.setEditor(textEditor);
        this.fToggleMarkOccurrencesAction.setEditor(textEditor);
        this.fPreviousAnnotation.setEditor(textEditor);
        this.fNextAnnotation.setEditor(textEditor);
        this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssistProposal"));
        this.fContextInformation.setAction(this.getAction(textEditor, "ContentAssistContextInformation"));
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        this.fGotoNextBookmark.setAction(this.getAction(textEditor, "GotoNextBookmark"));
        this.fGotoNextMemberAction.setAction(this.getAction(textEditor, "GotoNextMember"));
        this.fGotoPreviousMemberAction.setAction(this.getAction(textEditor, "GotoPrevMember"));
        this.fShowOutline.setAction(this.getAction(textEditor, "OpenOutline"));
        this.fToggleSourceHeader.setAction(this.getAction(textEditor, "ToggleSourceHeader"));
        this.fToggleInsertModeAction.setAction(this.getAction(textEditor, "TOGGLE_INSERT_MODE"));
        this.fFindWord.setAction(this.getAction(textEditor, "FindWord"));
        this.fExpandSelectionToEnclosing.setAction(this.getAction(textEditor, "StructureSelectEnclosing"));
        this.fExpandSelectionToNext.setAction(this.getAction(textEditor, "StructureSelectNext"));
        this.fExpandSelectionToPrevious.setAction(this.getAction(textEditor, "StructureSelectPrevious"));
        this.fExpandSelectionToHistory.setAction(this.getAction(textEditor, "StructureSelectHistory"));
        IActionBars bars = this.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ShiftRight", this.getAction(textEditor, "ShiftRight"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ShiftLeft", this.getAction(textEditor, "ShiftLeft"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Comment", this.getAction(textEditor, "Comment"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Uncomment", this.getAction(textEditor, "Uncomment"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.ToggleComment", this.getAction(textEditor, "ToggleComment"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Format", this.getAction(textEditor, "Format"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.AddBlockComment", this.getAction(textEditor, "AddBlockComment"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.RemoveBlockComment", this.getAction(textEditor, "RemoveBlockComment"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Indent", this.getAction(textEditor, "Indent"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.AddInclude", this.getAction(textEditor, "AddIncludeOnSelection"));
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.SortLines", this.getAction(textEditor, "SortLines"));
        IAction action = this.getAction(textEditor, ITextEditorActionConstants.REFRESH);
        bars.setGlobalActionHandler(ITextEditorActionConstants.REFRESH, action);
        bars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), this.getAction(textEditor, IDEActionFactory.ADD_TASK.getId()));
        bars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(textEditor, IDEActionFactory.BOOKMARK.getId()));
        bars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), this.getAction(textEditor, IDEActionFactory.OPEN_PROJECT.getId()));
        bars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), this.getAction(textEditor, IDEActionFactory.CLOSE_PROJECT.getId()));
        bars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), this.getAction(textEditor, IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId()));
        if (part instanceof CEditor) {
            CEditor cEditor = (CEditor)part;
            cEditor.fillActionBars(bars);
        }
    }

    public void dispose() {
        this.setActiveEditor(null);
        super.dispose();
    }
}

