/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.storage.dfs.DfsBlock;
import org.eclipse.jgit.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.storage.dfs.DfsPackKey;
import org.eclipse.jgit.storage.dfs.ReadableChannel;
import org.eclipse.jgit.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReadAheadTask
implements Callable<Void> {
    private final DfsBlockCache cache;
    private final ReadableChannel channel;
    private final List<BlockFuture> futures;
    private boolean running;

    ReadAheadTask(DfsBlockCache cache, ReadableChannel channel, List<BlockFuture> futures) {
        this.cache = cache;
        this.channel = channel;
        this.futures = futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() {
        int idx = 0;
        try {
            ReadAheadTask readAheadTask = this;
            synchronized (readAheadTask) {
                if (!this.channel.isOpen()) {
                    Void void_ = null;
                    return void_;
                }
                this.running = true;
            }
            long position = this.channel.position();
            while (idx < this.futures.size()) {
                if (Thread.interrupted()) return null;
                BlockFuture f = this.futures.get(idx);
                if (this.cache.contains(f.pack, f.start)) {
                    f.done();
                } else {
                    int size;
                    byte[] buf;
                    if (position != f.start) {
                        this.channel.position(f.start);
                    }
                    if (IO.read(this.channel, buf = new byte[size = (int)(f.end - f.start)], 0, size) != size) {
                        throw new EOFException();
                    }
                    this.cache.put(new DfsBlock(f.pack, f.start, buf));
                    f.done();
                    position = f.end;
                }
                ++idx;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            while (true) {
                if (idx >= this.futures.size()) {
                    this.close();
                }
                this.futures.get(idx).abort();
                ++idx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        for (BlockFuture f : this.futures) {
            f.abort();
        }
        ReadAheadTask readAheadTask = this;
        synchronized (readAheadTask) {
            if (!this.running) {
                this.close();
            }
        }
    }

    private synchronized void close() {
        try {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BlockFuture
    implements Future<Void> {
        private volatile State state = State.PENDING;
        private volatile Future<?> task;
        private final CountDownLatch latch = new CountDownLatch(1);
        final DfsPackKey pack;
        final long start;
        final long end;

        BlockFuture(DfsPackKey key, long start, long end) {
            this.pack = key;
            this.start = start;
            this.end = end;
        }

        synchronized void setTask(Future<?> task) {
            if (this.state == State.PENDING) {
                this.task = task;
            }
        }

        boolean contains(DfsPackKey want, long pos) {
            return this.pack == want && this.start <= pos && pos < this.end;
        }

        synchronized void done() {
            if (this.state == State.PENDING) {
                this.latch.countDown();
                this.state = State.DONE;
                this.task = null;
            }
        }

        synchronized void abort() {
            if (this.state == State.PENDING) {
                this.latch.countDown();
                this.state = State.CANCELLED;
                this.task = null;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Future<?> t = this.task;
            if (t == null) {
                return false;
            }
            boolean r = t.cancel(mayInterruptIfRunning);
            this.abort();
            return r;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.latch.await(timeout, unit)) {
                return null;
            }
            throw new TimeoutException();
        }

        @Override
        public boolean isCancelled() {
            State s = this.state;
            if (s == State.DONE) {
                return false;
            }
            if (s == State.CANCELLED) {
                return true;
            }
            Future<?> t = this.task;
            return t != null ? t.isCancelled() : true;
        }

        @Override
        public boolean isDone() {
            return this.state == State.DONE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            PENDING,
            DONE,
            CANCELLED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TaskFuture
    extends FutureTask<Void> {
        final ReadAheadTask task;

        TaskFuture(ReadAheadTask task) {
            super(task);
            this.task = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                this.task.abort();
                return true;
            }
            return false;
        }
    }
}

